#include <QtGui>

#include "SHtableAttributeDlg.h"
#include "tableProperty.h"
#include "mode1/DrawERDlg.h"
#include "mode1/erdiagram/Canvas.h"
#include "mode1/erdiagram/Table.h"
#include "mode1/erdiagram/NameRect.h"
#include "mode1/erdiagram/Name.h"
#include "mode1/erdiagram/PrimaryKeysRect.h"
#include "mode1/erdiagram/PrimaryKey.h"
#include "mode1/erdiagram/AttributesRect.h"
#include "mode1/erdiagram/Attribute.h"
#include "tableProperty.h"

SHtableAttributeDlg::SHtableAttributeDlg(Table* table, QWidget *parent)
: QDialog(parent)
{
	rowCurrentCount = 0; 
	
	tablePage	= new NewTablePage(this);
	applyBtn	= new QPushButton(tr("Ȯ"));
	cancelBtn	= new QPushButton(tr(""));
	
	connect(applyBtn, SIGNAL(clicked()), this, SLOT(ClickApply()));
	connect(cancelBtn, SIGNAL(clicked()), this, SLOT(ClickCancel()));
	
	QHBoxLayout * BtnLayout = new QHBoxLayout;
	BtnLayout->addWidget(applyBtn);
	BtnLayout->addWidget(cancelBtn);
	BtnLayout->setAlignment(Qt::AlignBottom | Qt::AlignRight);
	
    QVBoxLayout *TableLayout = new QVBoxLayout;
    TableLayout->addWidget(tablePage);
	TableLayout->addLayout(BtnLayout);
    setLayout(TableLayout);
	
	this->tableName = table->GetNameRect()->GetName()->toPlainText();
	setGeometry(0,0,800,400);
	
	this->table = table;
	
	MakeTableWidget(table);
	
	setWindowTitle(tr("̺ Ӽ ̾α"));
}


// ̾׷ ̺ Į  ѷ
void SHtableAttributeDlg::MakeTableWidget(Table* table)
{
	QTableWidget* tableWidget = this->GetTablePage()->TableProperty;
	
	//DrawERDlg::getInstance()->GetTables();
	
	int stateOfExist = 0;
	int index=0;
	
	//  ̺ Ʈ  ִ üũ...
	for( index = 0; index < DrawERDlg::getInstance()->GetTables().count(); index++){
		if( (DrawERDlg::getInstance()->GetTables())[index]->getTableName() == table->GetNameRect()->GetName()->toPlainText() ){
			stateOfExist = 1;
			break;
		}
	}
	
	//  ̺ Ʈ   
	if( stateOfExist == 1 ){
		
		qDebug() << "stateOfExist";
		qDebug() << (DrawERDlg::getInstance()->GetTables())[index]->getTableName();
		qDebug() << "FieldCount :" << (DrawERDlg::getInstance()->GetTables())[index]->fieldInfo.count();
		for( int i=0; i<(DrawERDlg::getInstance()->GetTables())[index]->fieldInfo.count(); i++ ){
			
			if( i >= tableWidget->rowCount() ){
				qDebug() << "Insert+++++++++++++++++++++++++++++";
				qDebug() << i << ", " << tableWidget->rowCount();
				tableWidget->insertRow(i);
			}
			
			QTableWidgetItem* item;
			
			if( (((DrawERDlg::getInstance()->GetTables())[index]->fieldInfo))[i]->getPrimaryKey() == true ){
				item = new QTableWidgetItem(QIcon("Images/column_pk.png"), QString(""));
				tableWidget->setItem(i, 0, item);
			}
			
			QTableWidgetItem* item1 = 
				new QTableWidgetItem((((DrawERDlg::getInstance()->GetTables())[index]->fieldInfo))[i]->getFieldName());
			tableWidget->setItem(i, 1, item1);
			
			this->GetTablePage()->createDataType();
			
			filedProperty* field = (((DrawERDlg::getInstance()->GetTables())[index]->fieldInfo))[i];
			
			qDebug() << "length--------- :" << field->getFieldLength();
			
			QString dataType = field->getFieldDataType();
			
			int index = 0;
			QString bufff;
			
			for( index = 0; index < this->GetTablePage()->TableType->count(); index++){
				if( this->GetTablePage()->TableType->itemText(index) == dataType ){
					break;
				}
			}

			this->GetTablePage()->TableType->setCurrentIndex(index);

			tableWidget->setCellWidget(i,2,this->GetTablePage()->TableType);
			item1 = new QTableWidgetItem(field->getFieldLength());
			tableWidget->setItem(i, 3, item1);
			
			if( field->getNotNull() == 2 ){
				QCheckBox* box = new QCheckBox();
				box->setCheckState(Qt::Checked);
				tableWidget->setCellWidget(i,4,box);
			}
			
			else{
				QCheckBox* box = new QCheckBox();
				box->setCheckState(Qt::Unchecked);
				tableWidget->setCellWidget(i,4,box);
			}
			
			qDebug() << "i : " << i;
			qDebug() << "Default :" << field->getDefaultVaule();
			qDebug() << "Comment :" << field->getComment();
			qDebug() << "tableWidget->rowCount() :" << tableWidget->rowCount();
			
			QString buffer1 = field->getDefaultVaule();
			QString buffer2 = field->getComment();
			
			item1 = new QTableWidgetItem(field->getDefaultVaule());
			tableWidget->setItem(i, 5, item1);
			
			item1 = new QTableWidgetItem(field->getComment());
			tableWidget->setItem(i, 6, item1);
		}
	}
	
	//  ̺ Ʈ   
	else if( stateOfExist == 0 ){

		for( int i=0; i<table->GetPrimaryRect()->GetPrimaryKeys().count(); i++ ){
			if( i >= tableWidget->rowCount() ){
				tableWidget->insertRow(i);
			}
			
			QString fkState = (table->GetPrimaryRect()->GetPrimaryKeys())[i]->toPlainText();
			
			QTableWidgetItem* item;
			
			qDebug() << fkState;
			qDebug() << fkState[fkState.count()-1];
			
			// ܷŰ ... 
			if( fkState[fkState.count()-1] != ')' ){
				item = new QTableWidgetItem(QIcon("Images/column_pk.png"), QString(""));
				tableWidget->setItem(i, 0, item);
			}
			
			QTableWidgetItem* item1 = new QTableWidgetItem((table->GetPrimaryRect()->GetPrimaryKeys())[i]->toPlainText());
			tableWidget->setItem(i, 1, item1);
			
			this->GetTablePage()->createDataType();
			
			if( i != 0 ){
				tableWidget->setCellWidget(i,2,this->GetTablePage()->TableType);
				tableWidget->setItem(i, 3, new QTableWidgetItem(""));
				tableWidget->setCellWidget(i,4,new QCheckBox());
				tableWidget->setItem(i, 5, new QTableWidgetItem(""));
				tableWidget->setItem(i, 6, new QTableWidgetItem(""));
			}
		}
		
		
		for( int i=0; i<table->GetAttributesRect()->GetAttributes().count(); i++ ){
			if( i+table->GetPrimaryRect()->GetPrimaryKeys().count() >= tableWidget->rowCount() ){
				tableWidget->insertRow(i+table->GetPrimaryRect()->GetPrimaryKeys().count());
			}
			
			QTableWidgetItem* item = new QTableWidgetItem((table->GetAttributesRect()->GetAttributes())[i]->toPlainText());
			tableWidget->setItem(i+table->GetPrimaryRect()->GetPrimaryKeys().count(), 1, item);
			
			this->GetTablePage()->createDataType();
			
			tableWidget->setCellWidget(i+table->GetPrimaryRect()->GetPrimaryKeys().count(),2,this->tablePage->TableType);
			tableWidget->setItem(i+table->GetPrimaryRect()->GetPrimaryKeys().count(), 3, new QTableWidgetItem(""));
			tableWidget->setCellWidget(i+table->GetPrimaryRect()->GetPrimaryKeys().count(),4,new QCheckBox());
			tableWidget->setItem(i+table->GetPrimaryRect()->GetPrimaryKeys().count(), 5, new QTableWidgetItem(""));
			tableWidget->setItem(i+table->GetPrimaryRect()->GetPrimaryKeys().count(), 6, new QTableWidgetItem(""));
		}
	}
}

void SHtableAttributeDlg::ClickApply()
{
	QMessageBox::StandardButton closeMessage;
	closeMessage = QMessageBox::warning(this, tr("ϱ"),
		tr("  մϴ.\n"
		" Ͻðڽϱ?"),
		QMessageBox::No | QMessageBox::Yes);
	
	// 
	if (closeMessage == QMessageBox::Yes){
		
		bool		primaryKey;		
		QString	fieldName;		
		QString	fieldDataType;	
		QString	fieldLength;	
		int		notNull;		
		QString	defaultVaule;	
		QString	comment;
		
		QTableWidget* table = this->GetTablePage()->TableProperty;
		tableProperty* buffer;
		
		qDebug() << "table->rowCount()" << table->rowCount();
		
		buffer = new tableProperty(); 
		buffer->setTableName(this->tableName);

		int fk = 0;
		
		// ̾׷ ̺ Ÿ .. 
		for(int i=0; i<table->rowCount(); i++){
			
			qDebug() << "i:" << i;
			
			filedProperty* fields;
			
			if( table->item(i, 1)->text() != "" ){
				
				if( table->item(i, 0) != 0 ){
					primaryKey = 1;
				}
				
				else{
					primaryKey = 0;
				}

				QString buffer1 = table->item(i,1)->text();

				if( (table->item(i,1)->text())[table->item(i,1)->text().size()-1] == ')' ){
					QString buffer = table->item(i,1)->text();
					
					buffer1 = buffer.left(table->item(i,1)->text().size()-4);

					qDebug() << "buffer++++++++++++++++++++" << buffer1;
				}

				fieldName = buffer1;
				fieldDataType = ((QComboBox*)(table->cellWidget(i,2)))->currentText();
				fieldLength = table->item(i,3)->text();
				notNull = ((QCheckBox*)(table->cellWidget(i,4)))->checkState();
				defaultVaule = table->item(i,5)->text();
				qDebug() << "SaveDefault : " << defaultVaule;
				comment = table->item(i,6)->text();
				qDebug() << "SaveComment : " << comment;
				
				fields = new filedProperty(primaryKey,fieldName,fieldDataType,fieldLength,notNull,defaultVaule,comment);

				buffer->fieldInfo << fields;
			}
		}
		
		qDebug() << "buffer->fieldInfo:" << buffer->fieldInfo.count();
		
		int state = 0;
		int index = 0;

		for( index=0; index< DrawERDlg::getInstance()->GetTables().count(); index++){
			if( (DrawERDlg::getInstance()->GetTables())[index]->getTableName() == this->tableName){
				state = 1;
				break;
			}
		}

		//if( state == 1 ){		//  
		//	(DrawERDlg::getInstance()->GetTables()).replace(index, buffer);
		//}
		//else if( state == 0 ){  // ..
			DrawERDlg::getInstance()->GetTables() << buffer;
		//}
		
		qDebug() << "Count : " << (DrawERDlg::getInstance()->GetTables())[0]->fieldInfo.count();
		qDebug() << "TableCount : " << (DrawERDlg::getInstance()->GetTables()).count();
		
		//  غ°.. 
		for( int i=0; i< DrawERDlg::getInstance()->GetTables().count(); i++){
			for( int j=0; j<(DrawERDlg::getInstance()->GetTables())[i]->fieldInfo.count(); j++){
				tableProperty* buffer = ((DrawERDlg::getInstance()->GetTables())[i]);
				
				qDebug() << "0 : " << (buffer->fieldInfo)[j]->getPrimaryKey();
				qDebug() << "1 : " << (buffer->fieldInfo)[j]->getFieldName();
				qDebug() << "2 : " << (buffer->fieldInfo)[j]->getFieldDataType();
				qDebug() << "3 : " << (buffer->fieldInfo)[j]->getFieldLength();
				qDebug() << "4 : " << (buffer->fieldInfo)[j]->getNotNull();
				qDebug() << "5 : " << (buffer->fieldInfo)[j]->getDefaultVaule();
				qDebug() << "6 : " << (buffer->fieldInfo)[j]->getComment();
			}
		}
		
		int count = this->table->GetPrimaryRect()->GetPrimaryKeys().count() + 
			this->table->GetAttributesRect()->GetAttributes().count();
		
		// ̾׷ ÿ ʵ ߰....
		for( int i=0; i < table->rowCount(); i++ ){
			if( i >= count ){
				if( table->item(i, 1)->text() != "" ){
					if( table->item(i, 0) != 0){
						this->table->GetPrimaryRect()->InsertPrimaryKey(table->item(i,1)->text());
					}
					else{
						this->table->GetAttributesRect()->InsertAttribute(table->item(i,1)->text());
					}
				}
			}
		}
	}

	this->close();
}

void SHtableAttributeDlg::ClickCancel()
{
	reject();
}
